/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui.filepanel;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import wjhk.jupload2.policies.UploadPolicy;

public class SizeRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -2029129064667754146L;
    private UploadPolicy uploadPolicy = null;
    private static final double gB = 1.073741824E9;
    private static final double mB = 1048576.0;
    private static final double kB = 1024.0;

    public SizeRenderer(UploadPolicy uploadPolicy) {
        this.uploadPolicy = uploadPolicy;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof Long) {
            this.setValue(SizeRenderer.formatFileSize(((Long)value).longValue(), this.uploadPolicy));
            super.setHorizontalAlignment(4);
        } else if (value != null) {
            this.uploadPolicy.displayWarn("value is not an instance of Long, in SizeRenderer.getTableCellRendererComponent(");
        }
        return cell;
    }

    public static String formatFileUploadSpeed(double fileUploadSpeedParam, UploadPolicy uploadPolicy) {
        String unit;
        double fileUploadSpeed = fileUploadSpeedParam;
        if (fileUploadSpeed >= 1.073741824E9) {
            fileUploadSpeed /= 1.073741824E9;
            unit = uploadPolicy.getLocalizedString("speedunit_gb_per_second", new Object[0]);
        } else if (fileUploadSpeed >= 1048576.0) {
            fileUploadSpeed /= 1048576.0;
            unit = uploadPolicy.getLocalizedString("speedunit_mb_per_second", new Object[0]);
        } else if (fileUploadSpeed >= 1024.0) {
            fileUploadSpeed /= 1024.0;
            unit = uploadPolicy.getLocalizedString("speedunit_kb_per_second", new Object[0]);
        } else {
            unit = uploadPolicy.getLocalizedString("speedunit_b_per_second", new Object[0]);
        }
        String value = String.format("%1$,3.2f %2$s", fileUploadSpeed, unit);
        if (uploadPolicy.getDebugLevel() >= 80 && value.contains("Infinity")) {
            uploadPolicy.displayDebug("'" + value + "' for values: fileUploadSpeed=" + fileUploadSpeed + " and unit=" + unit, 80);
        }
        return value;
    }

    public static String formatFileSize(double fileSize, UploadPolicy uploadPolicy) {
        String unit;
        String sizeunit_gigabytes = uploadPolicy.getLocalizedString("unitGigabytes", new Object[0]);
        String sizeunit_megabytes = uploadPolicy.getLocalizedString("unitMegabytes", new Object[0]);
        String sizeunit_kilobytes = uploadPolicy.getLocalizedString("unitKilobytes", new Object[0]);
        String sizeunit_bytes = uploadPolicy.getLocalizedString("unitBytes", new Object[0]);
        double fileSizeToDisplay = fileSize;
        if (fileSizeToDisplay >= 1.073741824E9) {
            fileSizeToDisplay /= 1.073741824E9;
            unit = sizeunit_gigabytes;
        } else if (fileSizeToDisplay >= 1048576.0) {
            fileSizeToDisplay /= 1048576.0;
            unit = sizeunit_megabytes;
        } else if (fileSizeToDisplay >= 1024.0) {
            fileSizeToDisplay /= 1024.0;
            unit = sizeunit_kilobytes;
        } else {
            unit = sizeunit_bytes;
        }
        return String.format("%1$,3.2f %2$s", fileSizeToDisplay, unit);
    }
}

